#!/usr/bin/wish

# Mystop verson .002
#
# A stop motion creation program using tcl/tk and tvtime
# make sure to install tvtime, mencoder, tcl, tk, mplayer, and gnome-mplayer
# before using.
# In Debian/Ubunto, you'll need to run: sudo apt-get install tcl tk mencoder mplayer gnome-mplayer
# In Redhat/Fedora, you'll need to run: yum install tcl tk mencoder mplayer gnome-mplayer
# (To get mplayer and gnome-mplayer you will have to install a third party repository such as rpmfusion)
#
# Created by Phillip J Rhoades
# http://ungab.com
# http://philliprhoades.com
# semjaza@gmail.com
#
# mplayer version updated by Kevin Fowler
# http://kevinfowler.net/mystop-mplayer
# foss@kevinfowler.net
#
# Released under the GPLv3 http://www.gnu.org/licenses/gpl.html
# use this command to make a video: mencoder mf://*.png -mf fps=15 -ovc lavc -o output.avi
#

# This is the fifo file used to send commands to mplayer
set fifo /tmp/$env(USER)-mplayer.fifo

# Clean the old fifo file
if [ file exists $fifo ] {
	exec rm $fifo
}

# Create a new fifo file and startup mplayer 
exec mkfifo $fifo
exec mplayer -slave -quiet -input file=$fifo -vf screenshot tv:// &

set shotcount 0
set partcount 0
set exittimelapse 1
# Set the variable below to 0 if you do not want it to delete the png files
#  after making the movie.
set deletefiles 1

button .takeshot -width 30 -height 10 -command tvshot -text "Take shot"
button .timelapse -width 30 -height 10 -command timelapse -text "Time Lapse"
button .makemovie -width 30 -height 10 -command makemovie -text "Make movie" 
label .partcount -width 30 -textvariable partcount
label .shotcount -width 30 -bg yellow -textvariable shotcount
label .makemovielbl -width 30 -bg green -textvariable makemovie
bind all <space> tvshot

proc tvshot {} {
	global shotcount
	global fifo
	set shotform [format "%05i" $shotcount]
	catch {exec echo "screenshot 0" > $fifo} mydummy
	set shotcount [expr $shotcount + 1]
}

proc timelapse {} {
	global shotcount
	global partcount
	global fifo
	global exittimelapse

	if { $exittimelapse == 0 } {
		set exittimelapse 1
		return
	}

	set exittimelapse 0
	
	while {0 == 0} {
		update
		set shotform [format "%05i" $shotcount]
		catch {exec echo "screenshot 0" > $fifo} mydummy
		set shotcount [expr $shotcount + 1]
		update
		set partcount 0
		while {$partcount < 5000} {
			if { $exittimelapse == 1 } {
				set partcount 0
				return
			}
			after 100
			update
			set partcount [expr $partcount + 100]
		}
	}
}


proc makemovie {} {
	global shotcount
	global partcount
	global makemovie
	global deletefiles

	.makemovie configure -state disabled

	set file [tk_getSaveFile -title "AVI Filename" -parent .]
	if { $file != "" } {
		set theexec [open "|mencoder mf://*.png -mf fps=10 -ovc lavc -o $file"]
		update
		while {![eof $theexec]} {
			set makemovie [gets $theexec]
			update
		}
		# If you don't want the png files automatically removed after avi is compile,
		#   then  comment out the next line.
		if { $deletefiles == 1 } {
			eval file delete [glob *.png]
		}
		set shotcount 0
		set partcount 0
		exec gnome-mplayer $file &
	}
	.makemovie configure -state normal
}

pack .shotcount
pack .takeshot
pack .timelapse
pack .partcount
pack .makemovie
pack .makemovielbl
